% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_range_map.R
\name{ensemble_range_map}
\alias{ensemble_range_map}
\title{Generate ensemble predictions from S4DM range maps}
\usage{
ensemble_range_map(
  occurrences,
  env,
  method = NULL,
  presence_method = NULL,
  background_method = NULL,
  bootstrap = "none",
  bootstrap_reps = 100,
  quantile = 0.05,
  constraint_regions = NULL,
  background_buffer_width = NULL,
  ...
)
}
\arguments{
\item{occurrences}{Presence coordinates in long,lat format.}

\item{env}{Environmental SpatRaster(s)}

\item{method}{Optional. If supplied, both presence and background density estimation will use this method.}

\item{presence_method}{Optional. Method for estimation of presence density.}

\item{background_method}{Optional. Method for estimation of background density.}

\item{bootstrap}{Character.  One of "none" (the default, no bootstrapping),
"numbag" (presence function is bootstrapped),
or "doublebag" (presence and background functions are bootstrapped).}

\item{bootstrap_reps}{Integer.  Number of bootstrap replicates to use (default is 100)}

\item{quantile}{Quantile to use for thresholding.  Default is 0.05 (5 pct training presence). Set to 0 for minimum training presence (MTP).}

\item{constraint_regions}{See get_env_bg documentation}

\item{background_buffer_width}{Numeric or NULL.  Width (meters or map units) of buffer to use to select background environment. If NULL, uses max dist between nearest occurrences.}

\item{...}{Additional parameters passed to internal functions.}
}
\value{
List object containing elements (1) spatRaster ensemble layer showing the proportion of maps that are included in the range across the ensemble,
(2) spatRasters for individual models, and (3) model quality information.
}
\description{
This function evaluates model quality and creates an ensemble of the model outputs.
This function uses 5-fold, spatially stratified, cross-validation to evaluate distribution model quality.
}
\details{
Current plug-and-play methods include: "gaussian", "kde","vine","rangebagging", "lobagoc", and "none".
Current density ratio methods include: "ulsif", "rulsif".
}
\note{
Either \code{method} or both \code{presence_method} and \code{background_method} must be supplied.
}
\examples{
\donttest{


# load in sample data

 library(S4DM)
 library(terra)

 # occurrence points
   data("sample_points")
   occurrences <- sample_points

 # environmental data
   env <- rast(system.file('ex/sample_env.tif', package="S4DM"))

 # rescale the environmental data

   env <- scale(env)

ensemble <- ensemble_range_map(occurrences = occurrences,
                               env = env,
                               method = NULL,
                               presence_method = c("gaussian", "kde"),
                               background_method = "gaussian",
                               quantile = 0.05,
                               background_buffer_width = 100000  )
}
}
