% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HadamardOCDs.R
\name{HadamardOCDs}
\alias{HadamardOCDs}
\title{Hadamard Method for Optimal Covariate Designs (OCDs)}
\usage{
HadamardOCDs(design)
}
\arguments{
\item{design}{Input a design in matrix format and block size k is multiple of 4.}
}
\value{
Generates W matrices and Inter product sums of W matrices.
}
\description{
Construct Hadamard matrix H_k = (1, h_1 , h_2,..., h_k-1) where k is the block size of the required design. Then superimpose each columns of H_k leaving the first column which is in natural order separately into the N matrix to get the W matrices. The maximum number of W matrices will be k-1.
}
\examples{
library(SFOCDs)
mat<-matrix(c(1,2,3,4,1,2,4,5,1,3,4,5,2,3,4,5),nrow=4,byrow=TRUE)
HadamardOCDs(mat)
}
\references{
Das, K., N. K. Mandal, and B. K. Sinha. (2003) <https://doi.org/10.1016/S0378-3758(02)00151-9>. Optimal experimental designs for models with covariates. Journal of Statistical Planning and Inference 115(1): 273-285.

Bansal, N., and D. K. Garg. (2022)<https://doi.org/10.1007/s42519-022-00244-0>. Optimum covariate designs for three associate PBIB designs. Journal of Statistical Theory and Practice 16(3): 1-15.
}
\author{
Neethu RS

Cini Varghese

Mohd Harun

Anindita Datta

Ashutosh Dalal
}
