% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{calcQueensPHomBrood}
\alias{calcQueensPHomBrood}
\alias{pHomBrood}
\alias{nHomBrood}
\title{The expected proportion and a realised number of csd homozygous brood}
\usage{
calcQueensPHomBrood(x, simParamBee = NULL)

pHomBrood(x, simParamBee = NULL)

nHomBrood(x, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link[AlphaSimR]{Pop-class}}, \code{\link[SIMplyBee]{Colony-class}}, or
\code{\link[SIMplyBee]{MultiColony-class}}}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
numeric, expected csd homozygosity named by colony id when \code{x}
  is \code{\link[SIMplyBee]{MultiColony-class}}
}
\description{
Level 0 functions that calculate or report the proportion of csd
  homozygous brood of a queen or a colony. The csd locus determines viability
  of fertilised eggs (brood) - homozygous brood is removed by workers. These
  functions 1) calculate the expected proportion of homozygous brood from the
  csd allele of the queen and fathers, 2) report the expected proportion of
  homozygous brood, or 3) report a realised number of homozygous brood due to
  inheritance process. See \code{vignette(package = "SIMplyBee")} for more
  details.
}
\section{Functions}{
\itemize{
\item \code{pHomBrood()}: Expected percentage of csd homozygous brood
of a queen / colony

\item \code{nHomBrood()}: Realised number of csd homozygous brood
produced by a queen

}}
\examples{
# This is a bit long example - the key is at the end!
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 120, nDrones = 20)
colony <- addVirginQueens(x = colony, nInd = 1)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 100, nDrones = 10)

# Virgin queen
try(calcQueensPHomBrood(basePop[5]))

# Queens of colony
calcQueensPHomBrood(colony)

# Queens of apiary
calcQueensPHomBrood(apiary)

# Inbreed virgin queen with her brothers to generate csd homozygous brood
colony2 <- createColony(x = getVirginQueens(colony))
colony2 <- cross(x = colony2, drones = pullDrones(x = colony, nInd = nFathersPoisson())[[1]])

# Calculate the expected csd homozygosity
calcQueensPHomBrood(getQueen(colony2))
pHomBrood(colony2)

# Evaluate a realised csd homozygosity
nHomBrood(addWorkers(colony2, nInd = 100))
nHomBrood(addWorkers(colony2, nInd = 100))
# nHomBrood will vary between function calls due to inheritance process
}
\seealso{
Demo in the introductory vignette
  \code{vignette("Honeybee_biology", package="SIMplyBee")}
}
