% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diagnostics.R
\name{plotDiagnostics}
\alias{plotDiagnostics}
\title{Plot Results from Diagnostics Collected During Model Fitting}
\usage{
plotDiagnostics(
  object,
  ind = max(object$diagnostics$penalty),
  xvar = c("time", "iteration")
)
}
\arguments{
\item{object}{an object of class \code{"SLOPE"}.}

\item{ind}{either "last"}

\item{xvar}{what to place on the x axis. \code{iteration} plots each iteration,
\code{time} plots the wall-clock time.}
}
\value{
Invisibly returns NULL. The function is called for its
side effect of producing a plot.
}
\description{
This function plots various diagnostics collected during
the model fitting resulting from a call to \code{\link[=SLOPE]{SLOPE()}} \emph{provided that
\code{diagnostics = TRUE}}.
}
\examples{
x <- SLOPE(abalone$x, abalone$y, diagnostics = TRUE)
plotDiagnostics(x)
}
\seealso{
\code{\link[=SLOPE]{SLOPE()}}
}
