% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/increase.stream.points.R
\name{increase.stream.points}
\alias{increase.stream.points}
\title{Add points to a line}
\usage{
increase.stream.points(l, freq = 1)
}
\arguments{
\item{l}{(shapefile) A projected polyline loaded with st_read(). Should include an id variable specifying different segments of the stream (this should be included even if there is only a single segment)}

\item{freq}{(numeric) Default = 1. The distance (in meters) to add points.}
}
\value{
A data frame of points consisting of three columns: lon (longitude), lat (latitude), id = stream segment identities (from the input shapefile)
}
\description{
Takes a polyline shapefile and adds points along the line between the existing points. Thus, a long straight section with only one point on either end will have points added along its length. Increasing the number of points will improve the accuracy of distance calculations but will greatly reducing the speed of all functions.
}
\details{
If you encounter a "LINESTRING EMPTY" warning, it means that your input shapefile had an ID for a segment that contained no data, and that segment was removed.
}
\keyword{internal}
