% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neur.representatives.R
\name{neur.representatives}
\alias{neur.representatives}
\title{Neuron representative}
\usage{
neur.representatives(SOM)
}
\arguments{
\item{SOM}{a kohonen SOM object.}
}
\value{
A vector containing the index of the representative frames for each neuron
}
\description{
Compute the representative frame of each neuron (the closest to the neuron codebook)
}
\examples{
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
#Compute representative frame for each neuron
neuron_representatives <- neur.representatives(som_model)
}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
