% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figures.R
\name{plotBins}
\alias{plotBins}
\title{Barplot of the most abundant bins in a SQM object}
\usage{
plotBins(
  SQM,
  count = "percent",
  N = 15,
  bins = NULL,
  others = TRUE,
  samples = NULL,
  ignore_unmapped = FALSE,
  ignore_nobin = FALSE,
  rescale = FALSE,
  color = NULL,
  base_size = 11,
  max_scale_value = NULL,
  metadata_groups = NULL
)
}
\arguments{
\item{SQM}{A SQM object.}

\item{count}{character. Either \code{"abund"} for raw abundances, \code{"percent"} for percentages, \code{"cov"} for coverages, or \code{"cpm"} for coverages per million reads (default \code{"percent"}).}

\item{N}{integer Plot the \code{N} most abundant bins (default \code{15}).}

\item{bins}{character. Custom bins to plot. If provided, it will override \code{N} (default \code{NULL}).}

\item{others}{logical. Collapse the abundances of least abundant bins, and include the result in the plot (default \code{TRUE}).}

\item{samples}{character. Character vector with the names of the samples to include in the plot. Can also be used to plot the samples in a custom order. If not provided, all samples will be plotted (default \code{NULL}).}

\item{ignore_unmapped}{logical. Don't include unmapped reads in the plot (default \code{FALSE}).}

\item{ignore_nobin}{logical. Don't include reads which are not in a bin in the plot (default \code{FALSE}).}

\item{rescale}{logical. Re-scale results to percentages (default \code{FALSE}).}

\item{color}{Vector with custom colors for the different features. If empty, we will use our own hand-picked pallete if N<=15, and the default ggplot2 palette otherwise (default \code{NULL}).}

\item{base_size}{numeric. Base font size (default \code{11}).}

\item{max_scale_value}{numeric. Maximum value to include in the y axis. By default it is handled automatically by ggplot2 (default \code{NULL}).}

\item{metadata_groups}{list. Split the plot into groups defined by the user: list('G1' = c('sample1', sample2'), 'G2' = c('sample3', 'sample4')) default \code{NULL}).}
}
\value{
a ggplot2 plot object.
}
\description{
This function selects the most abundant bins across all samples in a SQM object and represents their abundances in a barplot. Alternatively, a custom set of bins can be represented.
}
\examples{
data(Hadza)
# Bins distribution.
plotBins(Hadza)
}
\seealso{
\code{\link{plotTaxonomy}} for plotting the most abundant taxa of a SQM object; \code{\link{plotBars}} and \code{\link{plotHeatmap}} for plotting barplots or heatmaps with arbitrary data.
}
