#' Jumping and footwear
#'
#' Double-leg jumping distance, wearing shoes and barefoot.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 80 rows (each person) and 2 columns:
#' \describe{
#'   \item{Shoes}{The jumping distance, while wearing shoes, in cm}
#'   \item{Barefoot}{The jumping distance, while barefoot, in cm}
#' }
#' @source 
#' Hébert-Losier, K., Boswell-Smith, C., & Hanzlíková, I. (2023). 
#' Effect of Footwear Versus Barefoot on Double-Leg Jump-Landing and 
#' Jump Height Measures: A Randomized Cross-Over Study. 
#' \emph{International Journal of Sports Physical Therapy}, \bold{18}(4), 845.
#' 
#' 
#' @usage 
#' data(Jumping)
#' 
#' @examples
#' with(Jumping, hist(Barefoot - Shoes, xlab = "Increase barefoot (cm)", ylab = "Number people") )

"Jumping"
