#' Throttle
#'
#' Throttle and manifold air pressure.
#'  
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 68 rows (each student) and 2 columns:
#' \describe{
#'   \item{ThrottleAngle}{The throttle angle, in degrees}
#'   \item{MAPvalue}{The manifold air pressure, as a fraction of the maximum value}
#' }
#' @source 
#' Amin, Arslan Ahmed, and Khalid Mahmood-ul-Hasan. 2019.
#' Robust Active Fault-Tolerant Control for Internal Combustion Gas Engine 
#' for Air-Fuel Ratio Control with Statistical Regression-Based Observer Model. 
#' \emph{Measurement and Control}, 0020294018823031
#' 
#' @usage 
#' data(Throttle)
#' 
#' @examples
#' plot(MAPvalue ~ ThrottleAngle, data = Throttle, 
#'      ylab = "Manifold air pressure (% of max)", 
#'      xlab = "Angle (degrees)")
#' 

"Throttle"
