% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForwardFall.R
\docType{data}
\name{ForwardFall}
\alias{ForwardFall}
\title{Forward-falling women}
\format{
A data frame with 15 rows (one per patient) and 2 columns:
\describe{
  \item{LeanAngle}{The angle at which patients could lean forward 
        and still recover}
  \item{Group}{The age group; \code{1} means 'younger women' 
        and \code{2} mean 'older women'}
}
}
\source{
Wojcik, Laura A., Darryl G. Thelen, Albert B. Schultz, 
James A. Ashton-Miller, and Neil B. Alexander. 1999. 
Age and Gender Differences in Single-Step Recovery from a Forward Fall. 
\emph{Journal of Gerentology} \bold{54A} (1): M44--50.
}
\usage{
data(ForwardFall)
}
\description{
The forward-leaning angle before women fall over.
}
\examples{
boxplot( LeanAngle ~ factor(Group), data = ForwardFall, 
         names.arg = c("Younger", "Older"), 
         ylab = "Lean-forward angle", 
         xlab = "Age group")

}
\keyword{datasets}
