% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_calcSRscore.R
\name{calcSRscore}
\alias{calcSRscore}
\title{Create a Data Frame of SRscore}
\usage{
calcSRscore(srratio, threshold = c(-1, 1))
}
\arguments{
\item{srratio}{A data frame of SRratio.}

\item{threshold}{A vector of length 2 (x, y) indicating threshold values. \code{c(-1, 1)} is default.}
}
\value{
A data frame containing results.
}
\description{
SRscore is score value of genes based expression profiles across different research projects.
SRratio is required to calculate SRscore.
}
\examples{
grp <- "Series"
var1 <- "control_sample"
var2 <- "treated_sample"

ebg <- expand_by_group(MetadataABA,
                       grp,
                       var1,
                       var2)

SRratio <- calcSRratio(TranscriptomeABA,
                       var1,
                       var2,
                       ebg,
                       is.log2 = TRUE)

head(calcSRscore(SRratio, threshold = c(-1, 1)))

}
