% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SRscore_rank.R
\name{plot_SRscore_rank}
\alias{plot_SRscore_rank}
\title{Plot Ranked SRscore Values with Threshold-Based Highlighting}
\usage{
plot_SRscore_rank(srscore, threshold = c(1, -1))
}
\arguments{
\item{srscore}{A data.frame containing at least a column named \code{score},
representing SRscore values for genes.}

\item{threshold}{A numeric vector of length 2 specifying
\code{c(upper_threshold, lower_threshold)}.
Default is \code{c(1, -1)}.}
}
\value{
Invisibly returns the sorted SRscore vector.
The function produces a scatter plot as a side effect.
}
\description{
This function visualizes SRscore values sorted in descending order and colors
each point based on user-defined thresholds.
Genes with SRscore above the upper threshold are colored red (up-regulated),
those below the lower threshold are colored blue (down-regulated),
and values within the range are shown in black.
}
\details{
The function performs the following:
\itemize{
\item Validates input data.
\item Sorts SRscore values in descending order.
\item Colors each point based on whether its value is:
\itemize{
\item greater than or equal to the upper threshold (red)
\item less than or equal to the lower threshold (blue)
\item between the thresholds (black)
}
\item Produces a rank plot with a legend explaining the color mapping.
}
}
\examples{
df <- data.frame(
  gene = paste0("Gene", 1:10),
  score = c(-5, -3, -1, 0, 0.5, 1.2, 2, 3, 4, 5)
)

# Basic usage
plot_SRscore_rank(df)

# Custom thresholds
plot_SRscore_rank(df, threshold = c(2, -2))

}
