% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{MF_streams}
\alias{MF_streams}
\title{MF_streams: Middle Fork streams}
\format{
An object of class \code{sf} (inherits from \code{data.frame}) with 163 rows and 10 columns.
}
\source{
\code{MF_streams} are a modified version of the United States
National Hydrography Dataset
(http://nhd.usgs.gov/).
}
\usage{
MF_streams
}
\description{
\code{MF_streams} is an \code{sf} object with LINESTRING geometry representing a subset of
streams and rivers in the Middle Fork Basin, Idaho, USA.
}
\details{
The \verb{sf data.frame} contains a set of 163 features and 9 columns:
\itemize{
\item COMID: Common identifier of an NHD feature or relationship
\item GNIS_NAME: Feature name as found in the Geographic Names Information System
\item REACHCODE: Unique identifier for a reach. The first 8 digits contain the identifier for the HUC8 and the last 6 digits are a unique within-HUC8 identifier for the reach
\item FTYPE: three-digit integer used to classify hydrography features in the NHD and define subtypes
\item FCODE: Numeric code that contains the feature type and its attributes as found in the NHDFCode lookup table
\item AREAWTMAP: Area weighted mean annual precipitation (mm) at the lowermost location on the edge
\item SLOPE: Slope of the edge (cm/cm)
\item rcaAreaKm2: Reach contributing area (km2), which is the land area draining directly into each line segment.
\item h2oAreaKm2: Watershed area (km2) for the lowermost location (downstream end node) on the line segment
}
}
\keyword{datasets}
