% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_custom.R
\name{sc_table_custom}
\alias{sc_table_custom}
\alias{sc_recode}
\title{Create custom tables}
\usage{
sc_table_custom(
  db,
  measures = c(),
  dimensions = c(),
  language = c("en", "de"),
  add_totals = TRUE,
  key = NULL,
  recodes = NULL,
  dry_run = FALSE
)

sc_recode(field, map = NULL, total = FALSE)
}
\arguments{
\item{db}{The uid of a database. Must be of type \code{DATASET}}

\item{measures}{A character vector of uids for measures. Each entry must be
of type \code{MEASURE}, \code{STAT_FUNCTION} or \code{COUNT}.}

\item{dimensions}{A character vector of dimensions for the cube. Can be
either of type \code{FIELD} or type \code{VALUESET}. Those entries are referred to
as \code{fields} in the parsed API response}

\item{language}{The language to be used for labeling. "en"
(the default) will use English. "de" uses German.}

\item{add_totals}{Should totals be added for each classification field in
the json request? Ignored if \code{recodes} is used.}

\item{key}{(\code{string}) An API key. To display your key, call
\code{\link[=sc_browse_preferences]{sc_browse_preferences()}}.}

\item{recodes}{One or more recodes that were generated via \code{\link[=sc_recode]{sc_recode()}}.
If more than one recode is supplied, recodes should be concatenated with
\code{\link[=c]{c()}}.}

\item{dry_run}{If \code{TRUE}, no request is sent to the API. Instead, type
checks are performed and the json request is returned as a string.
Defaults to \code{FALSE}.}

\item{field}{An uid of a classification field to be recoded. The provided
uid should also be passed in the \code{dimensions} parameter of
\code{\link[=sc_table_custom]{sc_table_custom()}}.}

\item{map}{A list of ids for values (type \code{VALUE}) This can also be a nested
list if items should be grouped. See examples}

\item{total}{Add totals to the field? If \code{map} is provided, the totals
will correspond to the filtered data.}
}
\value{
\itemize{
\item for \code{\link[=sc_table_custom]{sc_table_custom()}}: an object of class \code{sc_table}
\item for \code{\link[=sc_recode]{sc_recode()}}: a \code{list} that is a suitable input for parameter
\code{"recode"} in \code{\link[=sc_table_custom]{sc_table_custom()}}
}
}
\description{
Define requests against the /table endpoint by providing
URIs to databases, measures and fields.
The URIs can be obtained using \code{\link[=sc_schema_db]{sc_schema_db()}}.
See the \href{https://statistikat.github.io/STATcubeR/articles/sc_table_custom.html}{Custom tables article}
for more details.
}
\section{Functions}{
\itemize{
\item \code{sc_recode()}: creates a recode object which can be used
for the \code{recode} parameter of \code{\link[=sc_table_custom]{sc_table_custom()}}

}}
\section{Schema objects in parameters}{

it is possible to pass \code{sc_schema} objects (usually generated by
\code{\link[=sc_schema_db]{sc_schema_db()}}) instead of ids in \code{\link[=sc_table_custom]{sc_table_custom()}} and \code{\link[=sc_recode]{sc_recode()}}.
If provided, the schema objects will be converted into ids via \verb{$id}.
}

\section{Error handling}{

Unfortunately, the API gives fairly vague error messages in case a
custom table request is ill defined. For this reason, \code{\link[=sc_table_custom]{sc_table_custom()}}
applies some simple heuristics and throws warnings if inconsistencies
in the provided parameters are recognized. The following conditions are
currently checked
\itemize{
\item the parameter \code{db} is of type \code{DATABASE}
\item all entries in \code{measures} are of type \code{MEASURE}, \code{COUNT} or
\code{STATFN}
\item all entries in \code{dimensions} are of type \code{VALUESET} or \code{FIELD}
\item all entries in \code{field} are of type \code{VALUESET} or \code{FIELD}
\item all entries in \code{map} are of type \code{VALUE}
\item all fields in \code{recodes} are also present in \code{dimensions}
\item the first two arguments of \code{sc_recode()} are consistent, i.e.
if the provided \code{VALUE}s belong to the \code{VALUESET/FIELD}
}
}

\examples{
\dontshow{if (sc_key_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sc_table_custom("str:database:detouextregsai")

sc_table_custom(
  "str:database:detouextregsai",
  dimensions = "str:field:detouextregsai:F-DATA1:C-SDB_TIT-0"
)

sc_table_custom(
  db = "str:database:detouextregsai",
  measures = c(
    "str:statfn:detouextregsai:F-DATA1:F-ANK:SUM",
    "str:measure:detouextregsai:F-DATA1:F-UEB"
  ),
  dimensions = c(
    "str:field:detouextregsai:F-DATA1:C-SDB_TIT-0",
    "str:valueset:detouextregsai:F-DATA1:C-C93-2:C-C93SUM-0"
  )
)

schema <- sc_schema_db("detouextregsai")
region <- schema$`Other Classifications`$`Tourism commune [ABO]`$
  `Regionale Gliederung (Ebene +1)`
month <- schema$`Mandatory fields`$`Season/Tourism Month`

x <- sc_table_custom(
  schema,
  schema$Facts$Arrivals,
  list(month, region),
  recodes = c(
    sc_recode(region, total = FALSE, map = list(
      region$Achensee,
      list(region$Arlberg, region$`Ausseerland-Salzkammergut`)
    )),
    sc_recode(month, total = FALSE)
  )
)
x$tabulate()
\dontshow{\}) # examplesIf}
}
