% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul_fun_noGEV_3d.R
\name{simul_fun_noGEV_3d}
\alias{simul_fun_noGEV_3d}
\title{Function to optimize the full pseudo-loglikelihood and perform new forecasts}
\usage{
simul_fun_noGEV_3d(
  nsim = 100,
  n_train,
  n_test,
  copula,
  init_params,
  fn,
  u1,
  u2,
  u3,
  z1_train,
  z2_train,
  z3_train,
  z1_test,
  z2_test,
  z3_test,
  X_t,
  y1_test,
  y2_test,
  y3_test,
  BSTS_1,
  BSTS_2,
  BSTS_3
)
}
\arguments{
\item{nsim}{Integer, number of simulation replications.}

\item{n_train}{Integer, number of training observations.}

\item{n_test}{Integer, number of test observations.}

\item{copula}{Character, specifying the copula type: "Clayton", "Frank",
"Gumbel", "Joe", or "Gaussian".}

\item{init_params}{Numeric vector, initial parameter values for optimization.}

\item{fn}{Function, log-likelihood function for parameter estimation.}

\item{u1}{Numeric vector (n_train), first pseudo-observation for the copula.}

\item{u2}{Numeric vector (n_train), second pseudo-observation for the copula.}

\item{u3}{Numeric vector (n_train), third pseudo-observation for the copula.}

\item{z1_train}{Numeric matrix (n_train x M), observed data for the first margin and sub-feature.}

\item{z2_train}{Numeric matrix (n_train x M), observed data for the second margin and sub-feature.}

\item{z3_train}{Numeric matrix (n_train x M), observed data for the third margin and sub-feature.}

\item{z1_test}{Numeric matrix (n_test x M), true future data for the first margin and sub-feature.}

\item{z2_test}{Numeric matrix (n_test x M), true future data for the second margin and sub-feature.}

\item{z3_test}{Numeric matrix (n_test x M), true future data for the third margin and sub-feature.}

\item{X_t}{Numeric matrix (n_train x M), risk factors for the dynamic copula parameter.}

\item{y1_test}{Numeric vector (n_test), true future values for the first response variable.}

\item{y2_test}{Numeric vector (n_test), true future values for the second response variable.}

\item{y3_test}{Numeric vector (n_test), true future values for the third response variable.}

\item{BSTS_1}{Fitted BSTS model for the first response variable.}

\item{BSTS_2}{Fitted BSTS model for the second response variable.}

\item{BSTS_3}{Fitted BSTS model for the third response variable.}
}
\value{
A list containing:
\item{theta_simulated}{Simulated copula parameters across replications.}
\item{y1_simulated}{Simulated values for the first response variable.}
\item{y2_simulated}{Simulated values for the second response variable.}
\item{y3_simulated}{Simulated values for the third response variable.}
\item{MSE}{Mean squared error for each simulation run.}
\item{optim_results}{Results from the optimization process.}
}
\description{
Function to optimize the full pseudo-loglikelihood and perform new forecasts
}
