% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_multinetwork.R
\name{visualize_spatial_multinetwork}
\alias{visualize_spatial_multinetwork}
\title{Visualize spatial relationships between multiple cell types}
\usage{
visualize_spatial_multinetwork(
  spatial_data,
  sample,
  reference_type,
  target_types,
  x_col = "pxl_row_in_fullres",
  y_col = "pxl_col_in_fullres",
  type_col = "Epi_strom",
  color_palette = NULL,
  point_alpha = 0.7,
  line_alpha = 0.5,
  point_size = 1.5,
  line_width = 0.3,
  show_legend = TRUE
)
}
\arguments{
\item{spatial_data}{Spatial coordinates data frame}

\item{sample}{Sample name in the spatial transcriptome data}

\item{reference_type}{Reference cell type (character vector of length 1)}

\item{target_types}{Target cell type(s) (character vector of 1 or more)}

\item{x_col}{Column name for x-coordinates}

\item{y_col}{Column name for y-coordinates}

\item{type_col}{Column name for cell type information}

\item{color_palette}{Named vector of colors for cell types}

\item{point_alpha}{Transparency level for points}

\item{line_alpha}{Transparency level for connection lines}

\item{point_size}{Size of points in plot}

\item{line_width}{Width of connection lines}

\item{show_legend}{Logical, whether to show legend}
}
\value{
A ggplot object showing the spatial relationships
}
\description{
Visualize spatial relationships between multiple cell types
}
\examples{
visualize_spatial_multinetwork(posi, sample="SP8",reference_type="Macrophage",
                     target_type=c("Epithelial_cells_A","Epithelial_cells_B"),
                     type_col = "celltype_ABCDepi")
}
