% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_calibration.R
\name{get_calibration}
\alias{get_calibration}
\title{get_calibration}
\usage{
get_calibration(calibration_data)
}
\arguments{
\item{calibration_data}{STIC calibration data frame with columns \code{"standard"} (units: µS/cm) and \code{"condUncal"} (units: lux).}
}
\value{
A fitted \code{lm} model object relating \code{SpC} to the uncalibrated conductivity values measured by the STIC
}
\description{
This is a function to fit specific conductivity (\code{SpC}) standards and uncalibrated conductivity measured by the STIC to a model object. This model can then be used to predict SpC values using \link{apply_calibration}. As of right now, only linear models are supported.
}
\examples{
head(calibration_standard_data)
lm_calibration <- get_calibration(calibration_standard_data)
summary(lm_calibration)

}
