% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_clean_ballots.R
\name{cleanBallots}
\alias{cleanBallots}
\title{Tries to Address \code{validateBallots()} Warning(s).}
\usage{
cleanBallots(x, cand.names = NULL)
}
\arguments{
\item{x}{a \code{data.frame} with rows as ballots and columns as candidates.}

\item{cand.names}{character vector of length equal to number of candidates
(needed when column names of \code{x} are missing or not unique).}
}
\value{
a \code{data.frame} compatible for \code{stv()} function.
}
\description{
The \code{cleanBallots()} function tries to clean data for use in \code{stv()}. 
Some warnings from \code{validateBallots()} can only be addressed by the user.
}
\details{
The \code{cleanBallots()} function assumes \code{x} contains rows and columns 
corresponding to ballots and candidates respectively. Formatting corrections 
are attempted in the following order:
\enumerate{
  \item If \code{x} is a \code{matrix} it is convered to a \code{data.frame}.
    Otherwise, user must provide a \code{data.frame}.
  \item If \code{x} has non-numeric entries, user must
    convert data to numeric type.
  \item If \code{cand.names} is specified, it is assigned as column names of \code{x}. 
  All collumn names must be uniquely specified.
  \code{x} already has valid column names, no need to specify \code{cand.names}.
  If column names of \code{x} missing and \code{cand.names} not specified, returns
  error message.
  \item Removes blank columns.
  \item Removes blank and/or non-sequentially ranked rows.
}
}
\examples{
data(ballots)
cballots <- cleanBallots(ballots)
validateBallots(cballots)
}
