% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funs.R
\name{plot_pptest}
\alias{plot_pptest}
\title{Plot point and interval predictions on testing data}
\usage{
plot_pptest(post_ypred, y_test, alpha_level = 0.1)
}
\arguments{
\item{post_ypred}{\code{nsave x n_test} samples
from the posterior predictive distribution at test points \code{X_test}}

\item{y_test}{\code{n_test} testing points}

\item{alpha_level}{alpha-level for prediction intervals}
}
\value{
plot of the testing data, point and interval predictions,
and a summary of the empirical coverage
}
\description{
Given posterior predictive samples at \code{X_test},
plot the point and interval estimates and compare
to the actual testing data \code{y_test}.
}
\examples{
\donttest{
# Simulate some data:
dat = simulate_tlm(n = 100, p = 5, g_type = 'step')

# Fit a semiparametric Bayesian linear model:
fit = sblm(y = dat$y, X = dat$X, X_test = dat$X_test)

# Evaluate posterior predictive means and intervals on the testing data:
plot_pptest(fit$post_ypred, dat$y_test,
            alpha_level = 0.10) # coverage should be about 90\%
}
}
