% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{dB_to_self_spectra}
\alias{dB_to_self_spectra}
\title{Convert dB Values to Self-Spectra Power}
\usage{
dB_to_self_spectra(dB_values, receiver_gain)
}
\arguments{
\item{dB_values}{A numeric vector. The power values in decibels (dB).}

\item{receiver_gain}{A numeric scalar. The receiver gain in decibels (dB).}
}
\value{
A numeric vector of self-spectra power values in linear scale.
}
\description{
This function converts power values expressed in decibels (dB) to linear self-spectra power values. The conversion is based on the given receiver gain, which accounts for the radar system's amplification effects.
}
\details{
The conversion from decibels to linear power follows the equation:
\deqn{P = 10^{(dB + G)/10}}
where:
\itemize{
\item \( P \) is the self-spectra power in linear scale,
\item \( dB \) represents the power values in decibels,
\item \( G \) is the receiver gain in decibels.
}
}
\seealso{
\code{\link{self_spectra_to_dB}} for the inverse operation.
}
