% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICSelectDOA}
\alias{seasonder_MUSICSelectDOA}
\title{Select Direction of Arrival (DOA) from MUSIC Algorithm Results}
\usage{
seasonder_MUSICSelectDOA(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the results of the MUSIC algorithm and associated metadata.}
}
\value{
An updated \code{SeaSondeRCS} object with the selected DOA stored in the MUSIC results and updated processing steps.
}
\description{
This function processes the results of the MUSIC algorithm, selects the relevant Direction of Arrival (DOA)
based on the specified retained solution, and updates the corresponding \code{SeaSondeRCS} object with the selected
DOA and updated processing steps.
}
\details{
The function performs the following steps:
\enumerate{
\item Updates the processing steps to indicate the start of the DOA selection process.
\item Retrieves the MUSIC algorithm results from the \code{SeaSondeRCS} object.
\item Maps the retained solution index to the corresponding DOA solution for each entry in the MUSIC results.
\item Stores the updated MUSIC results, including the selected DOA, back into the \code{SeaSondeRCS} object.
\item Updates the processing steps to indicate the end of the DOA selection process.
}
}
\section{Processing Steps}{

The function appends the following processing steps to the \code{ProcessingSteps} attribute of the \code{SeaSondeRCS} object:
\itemize{
\item Start of DOA selection.
\item End of DOA selection.
}
}

\seealso{
\code{\link{seasonder_setSeaSondeRCS_ProcessingSteps}} to manage processing steps.
\code{\link{seasonder_getSeaSondeRCS_MUSIC}} to retrieve MUSIC results.
\code{\link{seasonder_setSeaSondeRCS_MUSIC}} to update MUSIC results.
}
