% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_computeCenterDopplerBin}
\alias{seasonder_computeCenterDopplerBin}
\title{Compute the Center Doppler Bin}
\usage{
seasonder_computeCenterDopplerBin(seasonder_cs_object, nDoppler)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing metadata about
Doppler bins and other radar parameters.}

\item{nDoppler}{An integer representing the total number of Doppler bins.}
}
\value{
A numeric value representing the center Doppler bin. The calculation
assumes zero-based indexing from CODAR data files, but note that R
uses one-based indexing, which may result in differences compared to
CODAR's Radia Suite outputs.
}
\description{
This function calculates the center Doppler bin for a SeaSondeRCS object
based on the total number of Doppler bins. The center bin corresponds to
the bin representing zero Doppler frequency.
}
\details{
The center Doppler bin is computed as:
\eqn{center\_bin = nDoppler/2}
where nDoppler is the total number of Doppler bins. This represents
the bin at zero Doppler frequency in a zero-indexed system. Since R uses
one-based indexing, users might observe an offset when comparing the output
of this function to CODAR's Radia Suite programs.
}
\seealso{
\code{\link{seasonder_getSeaSondeRCS_MUSIC_nDopplerCells}} to retrieve the number
of Doppler cells from a SeaSondeRCS object.
}
