% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_createSeaSondeRCS}
\alias{seasonder_createSeaSondeRCS}
\title{Create a SeaSondeRCS object}
\usage{
seasonder_createSeaSondeRCS(x, specs_path = NULL, ...)
}
\arguments{
\item{x}{Either a character string specifying the path to the SeaSonde CS file or a list containing header and data.}

\item{specs_path}{A character string specifying the path to the YAML specifications for the CS file. Used only if \code{x} is a character string.}

\item{...}{Additional parameters passed to the underlying functions.}
}
\value{
A SeaSondeRCS object.
}
\description{
This generic function creates a SeaSondeRCS object either from a file path or directly from a list
containing header and data. When \code{x} is a character string, the function determines the file type
(either "CS", "CSSY" or "CSSW") by analyzing the spectra file and reads it using the appropriate reading function.
If \code{specs_path} is not provided (or set to \code{rlang::zap()}), the default YAML specifications path
corresponding to the detected file type is used.
}
\details{
For character inputs, the function first checks if the specified file exists.
It then determines the file type using \code{seasonder_find_spectra_file_type}. If the \code{specs_path}
parameter is not provided or is set to \code{rlang::zap()}, the default specifications file path is obtained
using \code{seasonder_defaultSpecsFilePath} based on the detected file type. The file is then read using the
appropriate reading function:
\itemize{
\item \code{seasonder_readSeaSondeCSFile} for CS files.
\item \code{seasonder_readSeaSondeRCSSYFile} for CSSY files.
\item \code{seasonder_readSeaSondeRCSSWFile} for CSSW files.
}
For list inputs, the SeaSondeRCS object is created directly from the provided header and data.
Additionally, a processing step is appended to the object using \code{seasonder_setSeaSondeRCS_ProcessingSteps}
with a creation step text that indicates the source.
}
\examples{
# Creating a SeaSondeRCS object from a list
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
specs_path <- seasonder_defaultSpecsFilePath("CS")
temp_obj <- seasonder_readSeaSondeCSFile(cs_file, specs_path)
cs_list <- list(header = temp_obj$header, data = temp_obj$data)
rcs_object <- seasonder_createSeaSondeRCS(cs_list)

# Creating a SeaSondeRCS object from a file path using default YAML specifications
rcs_object <- seasonder_createSeaSondeRCS(system.file("css_data/CSS_TORA_24_04_04_0700.cs", 
package = "SeaSondeR"))

# Creating a SeaSondeRCS object from a file path with a specified YAML specifications file
rcs_object <- seasonder_createSeaSondeRCS(
  system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR"),
  specs_path = seasonder_defaultSpecsFilePath("CS")
)
}
\seealso{
\code{\link{new_SeaSondeRCS}},
\code{\link{seasonder_readSeaSondeCSFile}},
\code{\link{seasonder_readSeaSondeRCSSWFile}},
\code{\link{seasonder_setSeaSondeRCS_ProcessingSteps}}
}
