% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_filterFORAmplitudes}
\alias{seasonder_filterFORAmplitudes}
\title{Filter First Order Region (FOR) Based on Amplitude Thresholds}
\usage{
seasonder_filterFORAmplitudes(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing spectral data and FOR parameters.}
}
\value{
The updated \code{SeaSondeRCS} object with the filtered FOR bins.
}
\description{
This function filters the First Order Region (FOR) Doppler bins based on amplitude thresholds.
It applies a combination of noise-based and peak power-based criteria to remove low-amplitude bins
that do not meet the required signal-to-noise ratio.
}
\details{
\strong{Steps in FOR Amplitude Filtering:}
\enumerate{
\item \strong{Retrieve First Order Parameters:}
\itemize{
\item The function extracts \code{flim} (Null Below Peak Power) and \code{noisefact} (Signal-to-Noise Factor)
from \code{\link{seasonder_getFOR_parameters}}.
}
\item \strong{Compute Noise Levels:}
\itemize{
\item Calls \code{\link{seasonder_computeNoiseLevel}} to estimate the average noise level across all range cells.
\item Converts the noise level into a filtering threshold by multiplying it by \code{noisefact}.
}
\item \strong{Extract Smoothed Self-Spectra Data:}
\itemize{
\item Retrieves the smoothed self-spectra (SSA3) using \code{\link{seasonder_getSeaSondeRCS_FOR_SS_Smoothed}}.
\item Extracts the FOR spectral power for each range cell using \code{\link{seasonder_extractFOR}}.
}
\item \strong{Determine Filtering Thresholds:}
\itemize{
\item Computes a power threshold for each FOR region by taking the maximum amplitude in the FOR region
and dividing it by \code{flim}.
}
\item \strong{Apply Filtering Conditions:}
\itemize{
\item A Doppler bin is retained if its power is greater than:
\itemize{
\item The noise threshold (computed from \code{noisefact}).
\item The power threshold computed from \code{flim}.
}
}
\item \strong{Store Filtered FOR in Object:}
\itemize{
\item Updates the SeaSondeRCS object with the filtered FOR bins.
}
}

This filtering ensures that only strong, reliable first-order Bragg signals are retained, reducing
the impact of noise and second-order contamination.
}
\seealso{
\itemize{
\item \code{\link{seasonder_computeNoiseLevel}} for computing noise levels.
\item \code{\link{seasonder_getSeaSondeRCS_FOR_SS_Smoothed}} for retrieving smoothed self-spectra.
\item \code{\link{seasonder_extractFOR}} for extracting FOR spectral power.
\item \code{\link{seasonder_setSeaSondeRCS_FOR}} for storing the filtered FOR data.
}
}
