% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_findFORNulls}
\alias{seasonder_findFORNulls}
\title{Identify Nulls in First Order Region (FOR) Across All Range Cells}
\usage{
seasonder_findFORNulls(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing spectral data and FOR parameters.}
}
\value{
The updated \code{SeaSondeRCS} object with the computed FOR nulls, maximum power, and bin indices.
}
\description{
This function locates the null points in the First Order Region (FOR) of a SeaSondeR cross-spectral object.
It smooths the self-spectra (SS) data, extracts the relevant Doppler bins, and determines the boundaries
of the first-order Bragg region for each range cell.
}
\details{
The function follows these steps:
\enumerate{
\item \strong{Smooth the Self-Spectra Data:} Calls \code{\link{seasonder_SmoothFORSS}} to apply a running mean filter.
\item \strong{Extract Smoothed Self-Spectra:} Retrieves the processed SS matrix using \code{\link{seasonder_getSeaSondeRCS_FOR_SS_Smoothed}}.
\item \strong{Identify the Doppler Center Bin:} Determines the central Doppler bin using \code{\link{seasonder_getCenterDopplerBin}}.
\item \strong{Segment the Spectrum:} Splits the smoothed SS data into:
\itemize{
\item The negative Bragg region (left side of the Doppler spectrum).
\item The positive Bragg region (right side of the Doppler spectrum).
}
\item \strong{Find Nulls in Each Region:} Uses \code{\link{seasonder_findFORNullsInSSMatrix}} to identify the null positions.
\item \strong{Store Results:} Extracts:
\itemize{
\item The First Order Region (\code{FOR}).
\item The maximum power (\code{MAXP}).
\item The Doppler bin index of the maximum power (\code{MAXP.bin}).
}
\item \strong{Update the SeaSondeRCS Object:} Saves the detected FOR boundaries and related metrics.
}
}
\seealso{
\itemize{
\item \code{\link{seasonder_findFORNullsInSpectrum}} for processing individual spectra.
\item \code{\link{seasonder_findFORNullsInSSMatrix}} for batch processing spectra across multiple range cells.
\item \code{\link{seasonder_getSeaSondeRCS_FOR_SS_Smoothed}} for retrieving smoothed SS data.
}
}
