% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getMUSICConfig}
\alias{seasonder_getMUSICConfig}
\title{Retrieve the MUSIC Configuration from a SeaSondeRCS Object}
\usage{
seasonder_getMUSICConfig(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing MUSIC data and options.}
}
\value{
A list containing:
\itemize{
\item \code{doppler_interpolation}: The Doppler interpolation factor.
\item \code{MUSIC_parameters}: The numeric vector of MUSIC parameters.
}
}
\description{
This function returns the key configuration parameters for the MUSIC algorithm from a SeaSondeRCS object.
}
\details{
The configuration is aggregated from the MUSIC_data attribute of the object for easy access.
}
\examples{
# Minimal example for seasonder_getMUSICConfig
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
config <- seasonder_getMUSICConfig(cs_obj)
print(config)
}
