% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getMUSICDualSolutionsProportion}
\alias{seasonder_getMUSICDualSolutionsProportion}
\title{Retrieve Proportion of Dual Solutions from MUSIC Data}
\usage{
seasonder_getMUSICDualSolutionsProportion(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing MUSIC data.}
}
\value{
A numeric value representing the dual solutions proportion, or NA if not set.
}
\description{
This function extracts the proportion of dual solutions from the MUSIC data in a SeaSondeRCS object.
}
\details{
The function checks the MUSIC_data attribute for a dual_solutions_proportion value.
If not available, it defaults to NA_real_.
}
\examples{
# Minimal example for seasonder_getMUSICDualSolutionsProportion
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
dual_prop <- seasonder_getMUSICDualSolutionsProportion(cs_obj)
print(dual_prop)
}
