% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonder_generics.R
\name{seasonder_getVersion}
\alias{seasonder_getVersion}
\title{Get the version value from a SeaSondeR object}
\usage{
seasonder_getVersion(seasonder_obj)
}
\arguments{
\item{seasonder_obj}{A SeaSondeR object.}
}
\value{
The version value.
}
\description{
Get the version value from a SeaSondeR object
}
\examples{
# Get version from a SeaSondeRCS object
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
value <- seasonder_getVersion(cs_obj)
print(value)
}
