% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_initSeaSondeRCS_MUSIC}
\alias{seasonder_initSeaSondeRCS_MUSIC}
\title{Initialize SeaSondeR MUSIC Data Structure}
\usage{
seasonder_initSeaSondeRCS_MUSIC(
  seasonder_cs_object,
  range_cells = NULL,
  doppler_bins = NULL
)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeR cross-spectral object containing metadata about the radar system.}

\item{range_cells}{An optional vector specifying the range cells to include. Defaults to all range cells in the object.}

\item{doppler_bins}{An optional vector specifying the Doppler bins to include. Defaults to all Doppler bins in the object.}
}
\value{
A tibble with initialized MUSIC analysis data for the specified range cells and Doppler bins.
}
\description{
This function initializes a data structure for storing MUSIC analysis results
for a given SeaSondeR cross-spectral object.
}
\details{
The function creates a tibble with pre-computed range, frequency, and radial velocity values
for the specified range cells and Doppler bins. It also initializes placeholders for MUSIC-related
parameters such as covariance matrices, eigen decompositions, projections, DOA solutions, and more.

Columns in the resulting tibble include:
\itemize{
\item \code{range_cell}: Range cell indices.
\item \code{doppler_bin}: Doppler bin indices.
\item \code{range}: Computed range values for the specified range cells.
\item \code{freq}: Computed frequency values for the specified Doppler bins.
\item \code{radial_v}: Computed radial velocities for the specified Doppler bins.
\item \code{cov}: Initialized covariance matrices (see \code{\link{seasonder_MUSICInitCov}}).
\item \code{eigen}: Initialized eigen decompositions (see \code{\link{seasonder_MUSICInitEigenDecomp}}).
\item \code{projections}: Initialized projection matrices (see \code{\link{seasonder_MUSICInitProjections}}).
\item \code{DOA_solutions}: Initialized DOA solutions (see \code{\link{seasonder_MUSICInitDOASolutions}}).
\item \code{eigen_values_ratio}: Placeholder for the ratio of eigenvalues.
\item \code{P1_check}: Logical placeholder for the P1 criterion (default is \code{TRUE}).
\item \code{retained_solution}: Placeholder for the type of retained solution (\code{"dual"} by default).
\item \code{DOA}: Placeholder for final DOA results.
\item \code{lonlat}: Placeholder for longitude and latitude data as a data frame.
}
}
\seealso{
\code{\link{seasonder_NULLSeaSondeRCS_MUSIC}} for a NULL initialized structure.
\code{\link{seasonder_MUSICInitCov}}, \code{\link{seasonder_MUSICInitEigenDecomp}},
\code{\link{seasonder_MUSICInitProjections}}, \code{\link{seasonder_MUSICInitDOASolutions}} for initializing individual components.
}
