% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonder_log.R
\name{seasonder_logAndMessage}
\alias{seasonder_logAndMessage}
\title{Log and Inform Message in SeaSondeR}
\usage{
seasonder_logAndMessage(msg, log_level = "info", calling_function = NULL, ...)
}
\arguments{
\item{msg}{A character string indicating the message to be logged and informed.}

\item{log_level}{A character string indicating the level of the log ("info", "error", "fatal"). Default is "info".}

\item{calling_function}{Function where the condition occurred. If NULL (default), the code determines the caller.}

\item{...}{Additional arguments passed to \code{rlang::inform} (if log_level="info") or \code{rlang::warn} (if log_level="error").}
}
\value{
Invisibly returns no value; used solely for its side effects of logging and messaging.
}
\description{
This function logs a message to the SeaSondeR logging system and also informs the message to the console.
It prefixes the message with the name of the calling function.
}
\examples{
my_function <- function() {
  seasonder_logAndMessage("This is a message", "info")
}
my_function()

}
