% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{seasonder_plotAPMLoops}
\alias{seasonder_plotAPMLoops}
\title{Plot APM Loops in a Polar Coordinate System}
\usage{
seasonder_plotAPMLoops(seasonder_apm_obj)
}
\arguments{
\item{seasonder_apm_obj}{A SeaSonde RAPM object containing the antenna pattern data.}
}
\value{
A ggplot object displaying the magnitude of the two loops as a function of bearings.
}
\description{
This function generates a polar plot of the antenna pattern loops from a SeaSonde RAPM object.
}
\examples{
# Plot loops from a test SeaSondeRAPM object
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
obj <- seasonder_readSeaSondeRAPMFile(apm_file)
plot <- seasonder_plotAPMLoops(obj)
}
