% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{seasonder_smoothAPM}
\alias{seasonder_smoothAPM}
\title{Smooth APM Data}
\usage{
seasonder_smoothAPM(seasonder_apm_object, smoothing)
}
\arguments{
\item{seasonder_apm_object}{A SeaSonde RAPM object containing raw antenna pattern data.}

\item{smoothing}{The number of points to use for the moving average smoothing.}
}
\value{
The SeaSonde RAPM object with smoothed antenna pattern data and an updated processing step.
}
\description{
This function smooths the antenna pattern data for each channel of a SeaSonde RAPM object
by applying a moving average with a specified number of points.
}
\examples{
# Smooth antenna pattern data from a test SeaSondeRAPM object
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
obj <- seasonder_readSeaSondeRAPMFile(apm_file)
smoothed_obj <- seasonder_smoothAPM(obj, 5)
}
