% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_select_gamlss.R
\name{betareg_enet_gamlss}
\alias{betareg_enet_gamlss}
\title{Beta regression Elastic-Net via GAMLSS (gamlss.lasso)}
\usage{
betareg_enet_gamlss(
  X,
  Y,
  method = c("IC", "CV"),
  ICpen = c("BIC", "AIC", "HQC"),
  alpha = 1,
  trace = FALSE
)
}
\arguments{
\item{X}{Numeric matrix (n × p) of mean-submodel predictors.}

\item{Y}{Numeric response in (0,1). Values are squeezed to (0,1) internally.}

\item{method}{\code{"IC"} (information criterion) or \code{"CV"}.}

\item{ICpen}{Penalty for \code{"IC"} selection: \code{"BIC"}, \code{"AIC"}, or \code{"HQC"}.}

\item{alpha}{Elastic-net mixing (1 = LASSO, 0 = ridge).}

\item{trace}{Logical; print stepwise trace.}
}
\value{
Named numeric vector of coefficients as in \code{\link[=betareg_lasso_gamlss]{betareg_lasso_gamlss()}}.
}
\description{
Uses \code{gamlss.lasso::gnet()} to fit ENet on the mean submodel of
\code{gamlss(dist = BE)}. The routine assumes complete cases and does not expose
offsets or precision-model terms.
}
\seealso{
\code{\link[gamlss.lasso:gnet]{gamlss.lasso::gnet()}}, \code{\link[gamlss:gamlss]{gamlss::gamlss()}}, \code{\link[gamlss.dist:BE]{gamlss.dist::BE()}}
}
