% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SettingsObjects.R
\name{createSccsDiagnosticThresholds}
\alias{createSccsDiagnosticThresholds}
\title{Create SCCS diagnostics thresholds}
\usage{
createSccsDiagnosticThresholds(
  mdrrThreshold = 10,
  easeThreshold = 0.25,
  timeTrendMaxRatio = 1.1,
  rareOutcomeMaxPrevalence = 0.1,
  eventObservationDependenceNullBounds = c(0.5, 2),
  eventExposureDependenceNullBounds = c(0.8, 1.25)
)
}
\arguments{
\item{mdrrThreshold}{What is the maximum allowed minimum detectable relative risk (MDRR)?}

\item{easeThreshold}{What is the maximum allowed expected absolute systematic error (EASE).}

\item{timeTrendMaxRatio}{The maximum global ratio between the observed and expected count for the
time stability diagnostic.}

\item{rareOutcomeMaxPrevalence}{The maximum allowed prevalence (proportion of people with the
outcome) allowed when restricting to first outcome only.}

\item{eventObservationDependenceNullBounds}{The bounds for the null hypothesis for the incidence
rate ratio of the end-of-observation probe window.}

\item{eventExposureDependenceNullBounds}{The bounds for the null hypothesis for the incidence
rate of the pre-exposure window.}
}
\value{
An object of type \code{SccsDiagnosticThresholds}.
}
\description{
Threshold used when calling \code{\link[=runSccsAnalyses]{runSccsAnalyses()}} to determine if we pass or fail diagnostics.
}
