% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_unique_feature.R
\name{find_unique_feature}
\alias{find_unique_feature}
\title{find_unique_feature}
\usage{
find_unique_feature(
  so,
  t1 = 5,
  t2 = 0.4,
  t3 = 0.3,
  t1p = 5,
  t2p = 0.7,
  t3p = 0.5,
  resolution = 1,
  min_set_size = 5
)
}
\arguments{
\item{so}{a SiFINeT object}

\item{t1}{feature gene selection parameter, lower threshold for 1st order connectivity in absolute network}

\item{t2}{feature gene selection parameter, lower threshold for 2nd order connectivity in absolute network}

\item{t3}{feature gene selection parameter, lower threshold for 3rd order connectivity in absolute network}

\item{t1p}{unique feature gene selection parameter, lower threshold for 1st order connectivity in positive sub-network}

\item{t2p}{unique feature gene selection parameter, lower threshold for 2nd order connectivity in positive sub-network}

\item{t3p}{unique feature gene selection parameter, lower threshold for 3rd order connectivity in positive sub-network}

\item{resolution}{resolution for louvain clustering of unique feature genes}

\item{min_set_size}{minimum size for a unique feature gene cluster to be a separate unique feature gene set}
}
\value{
SiFINeT object with fg_id (candidate feature gene index), uni_fg_id (candidate unique feature gene index), conn2 (connectivities in positive sub-network),
uni_cluster (cluster of candidate unique feature genes), selected_cluster (selected unique feature gene clusters), and unique feature genes in featureset updated.
}
\description{
The function finds the clustered unique feature genes
}
\details{
SiFINeT first find genes with high 1st (>= t1), 2nd (>= t2) and 3rd (>= t3) order connectivities in absolute network (conn) to be candidate feature genes.
Then a positive sub-network is created where only candidate feature gene nodes (fg_id) and edges with positive coexpression patterns (coexp >= thres) are included.
Feature genes genes with high 1st (>= t1p), 2nd (>= t2p) and at least moderate 3rd (>= t3p) order connectivities in positive sub-network (conn2) are chosen to be candidate unique feature genes.
Note that when the network is not too sparse, t3p should usually be smaller than t2p for the detection of unique feature genes in transition cell types.
The candidate unique feature genes are then separated into groups by louvain clustering (with resolution defined by the resolution parameter),
and among them large groups (number of genes greater than min_set_size) are chosen to be unique feature gene sets that represent different cell types.
}
