% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneset_topology.R
\name{geneset_topology}
\alias{geneset_topology}
\title{geneset_topology}
\usage{
geneset_topology(
  so,
  weightthres = 0.3,
  edge_method = 2,
  node_color = "black",
  shiftsize = 0.05,
  boundsize = 0.3,
  prefix = "",
  set_name = NULL
)
}
\arguments{
\item{so}{a SiFINeT object}

\item{weightthres}{edges between nodes (feature gene sets) with weight greater than weightthres would be shown in the plot}

\item{edge_method}{SiFINeT provides 2 methods of calculating edge weight.
The number of shared feature genes between feature gene sets would be used when edge_method = 1;
while the edge proportion between feature gene sets would be applied if edge_method = 2.}

\item{node_color}{color of nodes. Should have either length 1 or same length as the number of feature gene sets.}

\item{shiftsize}{set the distance between center of label and the corresponding feature gene sets node.}

\item{boundsize}{set the size of the boundary region.}

\item{prefix}{the prefix of the labels}

\item{set_name}{name of the gene sets}
}
\value{
A ggraph (ggplot) object
}
\description{
The function plots the topology network of the feature gene sets found by SiFINeT.
}
\details{
This function visualizes the output feature gene sets of SiFINeT in the form of network.
Number of shared feature genes or proportion of edges between feature gene sets could be used to weight the edges.
The layout of the nodes is created by create_layout function in ggraph package.
}
\references{
Thomas Lin Pedersen (2022). ggraph: An Implementation of
Grammar of Graphics for Graphs and Networks. R package
version 2.0.6. https://CRAN.R-project.org/package=ggraph
}
