% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{run_simulations_par_rom}
\alias{run_simulations_par_rom}
\title{Run Simulations for a Parallel Design with Ratio of Means (ROM) test}
\usage{
run_simulations_par_rom(
  nsim,
  n,
  muT,
  muR,
  SigmaT,
  SigmaR,
  lequi_tol,
  uequi_tol,
  alpha,
  dropout,
  typey,
  adseq,
  k,
  arm_seed_T,
  arm_seed_R,
  TART,
  TARR,
  vareq
)
}
\arguments{
\item{nsim}{Integer. The number of simulations to run.}

\item{n}{Integer. The sample size per arm (before dropout).}

\item{muT}{arma::vec. Mean vector for the treatment arm.}

\item{muR}{arma::vec. Mean vector for the reference arm.}

\item{SigmaT}{arma::mat. Covariance matrix for the treatment arm.}

\item{SigmaR}{arma::mat. Covariance matrix for the reference arm.}

\item{lequi_tol}{arma::rowvec. Lower equivalence thresholds for each endpoint.}

\item{uequi_tol}{arma::rowvec. Upper equivalence thresholds for each endpoint.}

\item{alpha}{arma::rowvec. Significance level for each endpoint.}

\item{dropout}{arma::vec. Dropout rates for each arm (T, R).}

\item{typey}{Integer vector indicating the classification of each endpoint, where \code{1} corresponds to a primary endpoint and \code{2} corresponds to a secondary endpoint.}

\item{adseq}{Boolean. If \code{TRUE}, applies sequential (hierarchical) testing.}

\item{k}{Integer. Minimum number of endpoints required for equivalence.}

\item{arm_seed_T}{arma::ivec. Random seed vector for the treatment group (one per simulation).}

\item{arm_seed_R}{arma::ivec. Random seed vector for the reference group (one per simulation).}

\item{TART}{Double. Treatment allocation ratio (proportion of subjects in treatment arm).}

\item{TARR}{Double. Reference allocation ratio (proportion of subjects in reference arm).}

\item{vareq}{Boolean. If \code{TRUE}, assumes equal variances across treatment and reference groups.}
}
\value{
The function returns an arma::mat storing simulation results row-wise for consistency
with R's output format. The first row (\code{totaly}) contains the overall equivalence decision
(1 for success, 0 for failure). The subsequent rows include equivalence decisions for each endpoint,
mean estimates for both treatment and reference groups, and corresponding standard deviations.
}
\description{
This function simulates a parallel-group trial across multiple iterations.
It evaluates equivalence across multiple endpoints using the
Ratio of Means (ROM) test.
}
\details{
Equivalence testing uses either the Ratio of Means (ROM) test,
applying predefined equivalence thresholds and significance levels. When hierarchical testing (\code{adseq})
is enabled, all primary endpoints must demonstrate equivalence before secondary endpoints are evaluated.
Dropout rates are incorporated into the sample size calculation to ensure proper adjustment.
Randomization is controlled through separate random seeds for the treatment and reference groups,
enhancing reproducibility.
}
\author{
Thomas Debray \email{tdebray@fromdatatowisdom.com}
}
