% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_interpolate_missingReadings.R
\name{interpolate_missingReadings}
\alias{interpolate_missingReadings}
\title{Interpolate missing readings}
\usage{
interpolate_missingReadings(timeseries, option = "linear", ...)
}
\arguments{
\item{timeseries}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object in which missing values shall be replaced}

\item{option}{Algorithm to be used. Accepts the following input:
\itemize{
   \item{"linear" - for linear interpolation using \link{approx} }
   \item{"spline" - for spline interpolation using \link{spline}}
   \item{"stine" - for Stineman interpolation using \link[stinepack]{stinterp}}
   }}

\item{...}{Additional parameters to be passed through to \link{approx} or \link{spline} interpolation functions}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object (dependent on given input at parameter x)
}
\description{
Interpolate missing readings
}
\details{
Missing values get replaced by values of a \link{approx}, \link{spline} or \link[stinepack]{stinterp} interpolation.
}
\author{
The implementation is adopted from the package imputeTS, function na.interpolate
(https://github.com/SteffenMoritz/imputeTS/blob/master/R/na.interpolation.R)
}
