% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_mcnemar.test.R
\name{p_mcnemar.test}
\alias{p_mcnemar.test}
\alias{gen_mcnemar.test}
\title{p-value from McNemar test simulation}
\usage{
p_mcnemar.test(
  n,
  prop,
  OR = NULL,
  prop.disc = NULL,
  two.tailed = TRUE,
  correct = TRUE,
  gen_fun = gen_mcnemar.test,
  return_analysis = FALSE,
  ...
)

gen_mcnemar.test(n, prop, ...)
}
\arguments{
\item{n}{total sample size}

\item{prop}{two-dimensional matrix of proportions/probabilities}

\item{OR}{instead of supplying the \code{prop} table, the
odds ratio can be specified instead \eqn{\pi_{12}/\pi_{21}}. Also requires
proportion of discordant pairings to be specified}

\item{prop.disc}{proportion of discordant pairings, \eqn{\pi_{12} + \pi_{21}}}

\item{two.tailed}{logical; should a two-tailed or one-tailed test be used?}

\item{correct}{logical; use continuity correction? Only applicable for
2x2 tables}

\item{gen_fun}{function used to generate the required discrete data.
Object returned must be a \code{matrix} with k rows and k columns
of counts. Default uses \code{\link{gen_mcnemar.test}}.
User defined version of this function must include the argument \code{...}}

\item{return_analysis}{logical; return the analysis object for further
extraction and customization?}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}
}
\value{
a single p-value
}
\description{
Generates two-dimensional sample data for McNemar test and
return a p-value. Uses \code{\link{mcnemar.test}}.
}
\examples{

# from ?mcnemar.test
Performance <- matrix(c(794, 86, 150, 570),
		   nrow = 2,
		   dimnames = list("1st Survey" = c("Approve", "Disapprove"),
		               "2nd Survey" = c("Approve", "Disapprove")))
(prop <- prop.table(Performance))

# one sample + test and resulting p-value
p_mcnemar.test(n=sum(Performance), prop=prop)

# return analysis model
p_mcnemar.test(n=sum(Performance), prop=prop, return_analysis=TRUE)

\donttest{

# post-hoc power (not recommended)
Spower(p_mcnemar.test(n=sum(Performance), prop=prop))

# odds ratio + discordant proportions supplied instead
OR <- prop[1,2] / prop[2,1]
disc <- prop[1,2] + prop[2,1]
p_mcnemar.test(n=50, OR=.25, prop.disc=disc, two.tailed=FALSE) |>
  Spower(replications=30000)

}

}
\seealso{
\code{\link{gen_mcnemar.test}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
