% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_usms_xml.R
\name{gen_usms_xml}
\alias{gen_usms_xml}
\title{Generate STICS usms xml file from a template or an input file}
\usage{
gen_usms_xml(
  file,
  param_df = NULL,
  template = NULL,
  stics_version = "latest",
  usms_out_file = lifecycle::deprecated(),
  usms_nb = lifecycle::deprecated(),
  usms_param = lifecycle::deprecated(),
  usms_in_file = lifecycle::deprecated()
)
}
\arguments{
\item{file}{Path (including name) of the usms file to generate.}

\item{param_df}{A table (df, tibble) containing the values of the parameters
to use (see details)}

\item{template}{Path of an USM xml file to be used as a template.
Optional, if not provided, the function will use a standard template
depending on the STICS version.}

\item{stics_version}{Name of the STICS version. Optional,
used if the \code{file} argument is not provided. In this case the function uses
a standard template associated to the STICS version.}

\item{usms_out_file}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{usms_out_file} is no
longer supported, use \code{file} instead.}

\item{usms_nb}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{usms_nb} is no
longer supported, use \code{NA} instead.}

\item{usms_param}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{usms_param} is no
longer supported, use \code{param_df} instead.}

\item{usms_in_file}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{usms_in_file} is no
longer supported, use \code{template} instead.}
}
\value{
an invisible xml_document object
}
\description{
Generate STICS usms xml file from a template or an input file
}
\details{
Please see \code{get_stics_versions_compat()} for the full list of
STICS versions that can be used for the argument \code{stics_version}.

\code{param_df} is a \code{data.frame} with the following format:\tabular{lrrl}{
   usm_name \tab datedebut \tab datefin \tab nomsol \cr
   USM_2017_T1_CI \tab 199 \tab 263 \tab USM_T1 \cr
   USM_2018_T1 \tab 264 \tab 570 \tab USM_T1 \cr
   BIN_CANPC_05_SEC_220-0-0_34K_CANPC05T3_Q \tab 199 \tab 263 \tab LF1 \cr
   BIN_AGT_04_IRR_220-0-0_33K_AGT04T2_Q \tab 264 \tab 570 \tab LF1 \cr
   AGA_ARB_13_IRR_220-0-0_37K_ARB13_C \tab 199 \tab 263 \tab F1 \cr
   AGA_ARB_13_SEC_220-0-0_37K_ARB13_C \tab 264 \tab 570 \tab LF1 \cr
   FRA_ARB_11_SEC_220-0-0_38K_E \tab 199 \tab 263 \tab LF1 \cr
   MAG_ARB_09_SEC_220-0-0_38K_E \tab 264 \tab 570 \tab LF1 \cr
   MAG_ARV_12_IRR_220-0-0_36K_ARV12_C \tab 199 \tab 263 \tab LF1 \cr
   MAG_ARV_12_SEC_220-0-0_36K_ARV12_C \tab 264 \tab 570 \tab LF1 \cr
   FRA_ARB_12_SEC_220-0-0_31K_ARB12_C \tab 199 \tab 263 \tab LF1 \cr
   FRA_ARB_13_SEC_220-0-0_37K_ARB13_C \tab 264 \tab 570 \tab LF1 \cr
}


The first column gives the usm name, all following columns give
the parameter values to put in the usms.xml file for each usm row.

The first column name must contain the keyword Usm or usm or USM
as a prefix to be detected (as shown in the table extract above).

If not given (the default, \code{NULL}), the function returns the template as is.
}
\examples{
xl_path <- download_usm_xl(file = "inputs_stics_example.xlsx")
usms_param_df <- read_params_table(file = xl_path, sheet_name = "USMs")
gen_usms_xml(
  file = file.path(tempdir(), "usms.xml"),
  param_df = usms_param_df
)

}
