% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copula_utils.R
\name{ordinal_to_cutpoints}
\alias{ordinal_to_cutpoints}
\title{Convert Ordinal Observations to Latent Cutpoints}
\usage{
ordinal_to_cutpoints(x, cutpoints, strict)
}
\arguments{
\item{x}{Integer vector with values in \code{1:(length(cutpoints) + 1)}.}

\item{cutpoints}{The cutpoints on the latent scale corresponding to
\eqn{\boldsymbol{c} = c(c_1, \cdots, c_{K - 1})}.}

\item{strict}{(boolean) See function description.}
}
\value{
Numeric vector with cutpoints corresponding to the values in \code{x}.
}
\description{
\code{\link[=ordinal_to_cutpoints]{ordinal_to_cutpoints()}} converts the ordinal endpoints to the corresponding
cutpoints of the underlying latent continuous variable. Let
\eqn{P(x \le k) = G(c_k)} where \eqn{G} is the distribution function of the
latent variable. \code{\link[=ordinal_to_cutpoints]{ordinal_to_cutpoints()}} converts \eqn{x} to \eqn{c_k} (or to
\eqn{c_{k - 1}}) if \code{strict = TRUE}.
}
