bootstrap = function(surv, status, X, Sigma_e, Psi, K, r, dist, shape,
                    scale, order, B, model) {


n = dim(X)[1]
p = dim(X)[2]


if(model =="PH") {
Est_beta = NULL
Est_theta = NULL
for(b in 1:B) {
id = sample(c(1:n),n,replace=TRUE)
y = surv[id]; delta = status[id]; x = X[id,]
est = SIMEX_PH(y, delta, x, Sigma_e, Psi, K, order)
Est_beta = rbind(Est_beta, as.vector(est$est_beta))
Est_theta = rbind(Est_theta, as.vector(est$est_theta))
}
    }

if(model =="AH") {
Est_beta = NULL
Est_theta = NULL
for(b in 1:B) {
id = sample(c(1:n),n,replace=TRUE)
y = surv[id]+runif(n, 1e-6, 1e-5); delta = status[id]; x = X[id,]
est = SIMEX_AH(y, delta, x, Sigma_e, Psi, K, order)
Est_beta = rbind(Est_beta, as.vector(est$est_beta))
Est_theta = rbind(Est_theta, as.vector(est$est_theta))
}
   }

if(model =="AFT") {
Est_beta = NULL
Est_theta = NULL
for(b in 1:B) {
id = sample(c(1:n),n,replace=TRUE)
y = surv[id]; delta = status[id]; x = X[id,]
est = SIMEX_AFT(y, delta, x, Sigma_e, Psi, K, dist, shape, scale, order)
Est_beta = rbind(Est_beta, as.vector(est$est_beta))
Est_theta = rbind(Est_theta, as.vector(est$est_theta))
}
  }
if(model =="TM") {
Est_beta = NULL
Est_theta = NULL
for(b in 1:B) {
id = sample(c(1:n),n,replace=FALSE)
y = surv[id]; delta = status[id]; x = X[id,]
est = SIMEX_TM(y, delta, x, Sigma_e, Psi, K, r, order)
Est_beta = rbind(Est_beta, as.vector(est$est_beta))
Est_theta = rbind(Est_theta, as.vector(est$est_theta))
}
  }


mean_beta = colMeans(Est_beta)
mean_theta = matrix(colMeans(Est_theta),p,p)
var_beta = abs(colMeans(Est_beta^2) - B*mean_beta^2)
var_theta = abs(matrix((colMeans(Est_theta^2) - B*colMeans(Est_theta)^2),p,p))
var_beta[which(var_beta == 0)] = var_beta[which(var_beta == 0)] + 0.001
var_theta[which(var_theta == 0)] = var_theta[which(var_theta == 0)] + 0.001
p_beta = mean_beta / sqrt(var_beta)
p_theta = mean_theta / sqrt(var_theta)



boot_list = list(mean_beta,
                 mean_theta,
                 var_beta,
                 var_theta,
                 p_beta,
                 p_theta    )

names(boot_list) = c("est_beta","est_theta",
                     "var(beta)", "var(theta)",
                     "p-value_beta", "p-value_theta")

return(boot_list)

}

