% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{epiworld-repnum}
\alias{epiworld-repnum}
\alias{get_reproductive_number}
\alias{epiworld_repnum}
\alias{plot.epiworld_repnum}
\alias{plot_reproductive_number}
\title{Reproductive number (Rt)}
\usage{
get_reproductive_number(x)

\method{plot}{epiworld_repnum}(
  x,
  y = NULL,
  ylab = "Average Rep. Number",
  xlab = "Day (step)",
  main = "Reproductive Number",
  type = "b",
  plot = TRUE,
  ...
)

plot_reproductive_number(x, ...)
}
\arguments{
\item{x}{An object of class \code{\link{epiworld_sir}}, \code{\link{epiworld_seir}}, etc.
(any model), or an object of class \link{epiworld_repnum}.}

\item{y}{Ignored.}

\item{ylab, xlab, main, type}{Further parameters passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{plot}{Logical scalar. If \code{TRUE} (default), the function will plot the
desired statistic.}

\item{...}{In the case of plot methods, further arguments passed to
\link[graphics:plot.default]{graphics::plot}.}
}
\value{
\itemize{
\item The \code{get_reproductive_number} function returns an object of class
\link{epiworld_repnum}.
}

\itemize{
\item The \code{plot} method for \code{epiworld_repnum} returns a plot of the reproductive
number over time.
}
}
\description{
Extraction and plotting of the reproductive number (Rt) by virus over time.
}
\details{
The \code{plot_reproductive_number} function is a wrapper around
\link{get_reproductive_number} that plots the result.
}
\examples{
# SEIR Connected model
seirconn <- ModelSEIRCONN(
  name              = "Disease",
  n                 = 10000,
  prevalence        = 0.1,
  contact_rate      = 2.0,
  transmission_rate = 0.8,
  incubation_days   = 7.0,
  recovery_rate     = 0.3
)

set.seed(937)
run(seirconn, 50)

# Retrieving (and plotting) the reproductive number
rp <- get_reproductive_number(seirconn)
plot(rp) # Also equivalent to plot_reproductive_number(seirconn)

}
\seealso{
Other Epidemiological metrics: 
\code{\link{epiworld-gentime}}
}
\concept{Epidemiological metrics}
\concept{model-utility-functions}
