% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf.sources.R
\name{taf.sources}
\alias{taf.sources}
\title{List Sources}
\usage{
taf.sources(type)
}
\arguments{
\item{type}{one of \code{"data"}, \code{"software"} or \code{"both"}.}
}
\value{
List of metadata entries.
}
\description{
List metadata entries from \code{DATA.bib}, \code{SOFTWARE.bib}, or both.
}
\note{
The functionality is similar to \code{read.bib}, with the addition of a
\code{type} field, indicating whether an entry is \code{data}
\code{software}.

This function is used internally by the \code{taf.boot} procedure and is
also useful when organizing a larger TAF project.
}
\examples{
\dontrun{
taf.sources("data")
taf.sources("software")
taf.sources("both")
}

}
\seealso{
\code{\link{taf.boot}} reads and processes metadata entries.

\code{\link{read.bib}} is the underlying function to read metadata entries.

\code{\link{process.entry}} processes a single metadata entry, in the list
format returned by \code{taf.sources}.
}
