\name{ANOVA_app}
\alias{ANOVA_app}
\title{Analysis of Variance (ANOVA)}
\description{
\code{ANOVA_app()} function opens an interactive and user friendly Shiny application that enables users to perform Analysis of Variance (ANOVA) for multi-trait experimental data based on the \strong{Randomized Block Design (RBD)} by uploading an Excel file.
}
\usage{
ANOVA_app()
}
\details{
The application is designed to perform ANOVA for datasets based on the \strong{Randomized Block Design (RBD)}.

Users can upload an Excel file (.xlsx or .xls) containing data for multiple traits. After uploading the file, users need to click the "Analyze" button.

Results are presented in a tabular format showing sources of variation, their respective degrees of freedom (Df), and the Mean Sum of Squares for each trait. Significance is also indicated.

\strong{The output table is downloadable in CSV format.}
}
\section{Data Format}{
The uploaded Excel file should be formatted as follows:

\itemize{
  \item First column: Replication
  \item Second column: Genotypes
  \item Subsequent columns: Trait values (e.g., DBH, PH, FW, SW, KW, OC)
}

Trait names should be concise. Example:
\itemize{
  \item DBH : Diameter at Breast Height
  \item PH : Plant Height
  \item FW : Fruit Weight
  \item SW : Seed Weight
  \item KW : Kernel Weight
  \item OC : Oil Content
}

\strong{Note:} The uploaded file name should not contain spaces. For example, use \code{Sample_Data.xlsx} instead of \code{Sample Data.xlsx}.

An example Excel file is available for download using the \code{Download Example Data} button within the application.

The example dataset includes:
\itemize{
  \item 170 genotypes
  \item 3 replications for each genotype
  \item 6 traits: DBH, PH, FW, SW, KW, OC
}
}

\value{
Opens a user-friendly interactive shiny application for performing ANOVA on experimental data.
}

\references{
Singh, R. K., & Chaudhary, B. D. (1977). Biometrical Methods in Quantitative Genetic Analysis.
}

\examples{
if(interactive()) ANOVA_app()
}
