% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enclosing_rad.R
\name{enclosing_radius}
\alias{enclosing_radius}
\title{Compute the enclosing radius for a dataset.}
\usage{
enclosing_radius(X, distance_mat = FALSE)
}
\arguments{
\item{X}{the input dataset, must either be a matrix or data frame.}

\item{distance_mat}{whether or not `X` is a distance matrix, default FALSE.}
}
\value{
the numeric enclosing radius.
}
\description{
The enclosing radius is the minimum (Euclidean distance) radius beyond which no topological changes will occur.
}
\examples{

# create a persistence diagram from a 2D Gaussian
df = data.frame(x = rnorm(n = 20,mean = 0,sd = 1),y = rnorm(n = 20,mean = 0,sd = 1))
  
# compute the enclosing radius from the point cloud
enc_rad <- enclosing_radius(df, distance_mat = FALSE)
  
# compute the distance matrix manually, stored as a matrix
dist_df <- as.matrix(dist(df))
  
# compute the enclosing radius from the distance matrix
enc_rad <- enclosing_radius(dist_df, distance_mat = TRUE)
}
\author{
Shael Brown - \email{shaelebrown@gmail.com}
}
