% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplicity.R
\name{test_multiplicity}
\alias{test_multiplicity}
\alias{test_multiplicity_nonnegative}
\alias{stat_multiplicity}
\alias{translate2multiplicity}
\title{Test eigenvalue multiplicity}
\usage{
test_multiplicity(x, mult, B = 1000, refbasis = "sample")

test_multiplicity_nonnegative(
  x,
  mult,
  B = 1000,
  maxit = 25,
  refbasis = "sample"
)

stat_multiplicity(x, mult, evecs = NULL, refbasis = "sample")

translate2multiplicity(x, mult)
}
\arguments{
\item{x}{A sample of matrices suitable for \code{\link[=as_fsm]{as_fsm()}}.}

\item{mult}{A vector specifying the eigenvalue multiplicity under the null hypothesis in descending order of eigenvalue size.}

\item{B}{Number of bootstrap samples. If \code{B = 'chisq'} then a chi-squared calibration is used instead.}

\item{refbasis}{Select the basis of the eigenspaces. See details.}

\item{maxit}{The maximum number of Newton steps allowed in empirical likelihood optimisation \insertCite{owen:2013}{TFORGE}.}

\item{evecs}{For debugging only. Supply eigenvectors of population mean.}
}
\value{
A \code{TFORGE} object (see \code{\link[=boot_calib]{boot_calib()}} or \code{\link[=chisq_calib]{chisq_calib()}}) including p-value of the test (slot \code{pval}) and the statistic for \code{x} (slot \code{t0}).
}
\description{
Tests the multiplicity of the eigenvalues a population's mean.
The test statistic is computed by \code{stat_multiplicity()}.
The null hypothesis is that the population mean has the specified the multiplicity of eigenvalues.
For unconstrained symmetric matrices or symmetric matrices with fixed trace use \code{test_multiplicity()}.
For matrices constrained to have non-negative eigenvalues use \code{test_multiplicity_nonnegative()}.
}
\details{
For \code{test_multiplicity()}, bootstrap resampling is conducted from the null hypothesis by first translating the original sample to satisfy the null hypothesis with \code{translate2multiplicity()}.
For \code{test_multiplicity_nonnegative()}, weighted bootstrapping is used (see 'Weighted Bootstrapping' below).

On \code{refbasis}:
An estimate of each eigenspace specified by \code{mult} can be obtained from the eigenvectors of the sample mean.
The eigenvectors create an orthonormal basis of the (estimated) eigenspace,
however the choice of orthonormal basis for the estimated eigenspace effects the performance.
This choice is specified by the parameter \code{refbasis}.
Setting \code{refbasis = "sample"} uses the eigenvectors of the sample mean as the basis, however the resulting statistic does not appear to be pivotal.
Choosing the orthonormal basis independently of the data does result in a pivotal asymptotically chi-squared statistic.
Setting \code{refbasis = "random"} will do exactly this, by applying a uniformly random rotation of the relevant eigenvectors of the sample mean.
We recommend using \code{refbasis = "sample"} (which requires bootstrap calibration) because test power is much higher than \code{refbasis = "random"}.
We recommend that the number bootstrap resamples is at least 1000 if \code{refbasis = "sample"}.

For 3x3 matrices, the weighted-bootstrapping method used by \code{test_multiplicity_nonnegative()} has poor test size for samples smaller than 20;
larger matrices will likely need larger samples.

Due to the random rotation of the eigenvectors when \code{refbasis = "random"}, use \code{\link[=set.seed]{set.seed()}} if you want the answer to be repeatable.
}
\section{Weighted Bootstrapping}{
This function uses a form of weighted bootstrapping called b-boostrapping \insertCite{hall1999in}{TFORGE}. An empirical distribution is defined by sampling weights for each observation in the original sample.
The sampling weights must be such that the (extrinsic) mean of the empirical distribution is \deqn{c\hat{Q} \Lambda \hat{Q}^\top,}
where \eqn{\hat{Q}} are the eigenvectors of the sample mean, \eqn{\Lambda} is a diagonal matrix of eigenvalues specified by either the null hypothesis (for single sample tests) or estimated as the common eigenvalues of multiple populations (for k-sample tests).
In some situations \eqn{c} is a free scalar to enable projection of the Euclidean mean to the extrinsic mean, otherwise \eqn{c=1}.
If no such sampling weights exist (i.e. the convex hull of the data does not contain \eqn{c\hat{Q} \Lambda \hat{Q}^\top}), then the test rejects with \code{pval=0} and a warning.

The sampling weights are also optimised to maximise empirical likelihood \insertCite{owen:2013}{TFORGE}.
}

\examples{
x <- rsymm_norm(15, mean = diag(c(2, 1, 1, 0)))
test_multiplicity(x, mult = c(1, 2, 1))
}
