#' Dataset A of the NN3 Competition 
#' 
#' The NN3 Competition dataset composed of monthly time series drawn from
#' homogeneous population of real empirical business time series. 
#' 
#' The NN3 Competition's Dataset A contains 111 different monthly time series.
#' Each of this time series possess from 50 to 126 observations. Each
#' competitor in NN3 was asked to predict the next 18 corresponding
#' observations of each times series (\code{\link{NN3.A.cont}}). The
#' performance evaluation done by NN3 Competition was based on the mean SMAPE
#' error of prediction found by the competitors across all time series. 
#' 
#' @name NN3.A
#' @docType data
#' @format A data frame with 126 observations on the following 111 variables.
#' \describe{ \item{NN3.001}{a numeric vector containing the 51
#' observations of a univariate time series.} \item{NN3.002}{a numeric
#' vector containing the 51 observations of a univariate time series.}
#' \item{NN3.003}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.004}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.005}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.006}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.007}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.008}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.009}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.010}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.011}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.012}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.013}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.014}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.015}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.016}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.017}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.018}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.019}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.020}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.021}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.022}{a numeric vector containing
#' the 50 observations of a univariate time series.} \item{NN3.023}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.024}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.025}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.026}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.027}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.028}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.029}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.030}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.031}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.032}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.033}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.034}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.035}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.036}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.037}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.038}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.039}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.040}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.041}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.042}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.043}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.044}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.045}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.046}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.047}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.048}{a numeric vector containing the 51 observations of a
#' univariate time series.} \item{NN3.049}{a numeric vector containing
#' the 51 observations of a univariate time series.} \item{NN3.050}{a
#' numeric vector containing the 51 observations of a univariate time series.}
#' \item{NN3.051}{a numeric vector containing the 123 observations of a
#' univariate time series.} \item{NN3.052}{a numeric vector containing
#' the 126 observations of a univariate time series.} \item{NN3.053}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.054}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3.055}{a numeric vector containing
#' the 126 observations of a univariate time series.} \item{NN3.056}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.057}{a numeric vector containing the 123 observations of a
#' univariate time series.} \item{NN3.058}{a numeric vector containing
#' the 122 observations of a univariate time series.} \item{NN3.059}{a
#' numeric vector containing the 116 observations of a univariate time series.}
#' \item{NN3.060}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3.061}{a numeric vector containing
#' the 126 observations of a univariate time series.} \item{NN3.062}{a
#' numeric vector containing the 122 observations of a univariate time series.}
#' \item{NN3.063}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3.064}{a numeric vector containing
#' the 116 observations of a univariate time series.} \item{NN3.065}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.066}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3.067}{a numeric vector containing
#' the 126 observations of a univariate time series.} \item{NN3.068}{a
#' numeric vector containing the 121 observations of a univariate time series.}
#' \item{NN3.069}{a numeric vector containing the 121 observations of a
#' univariate time series.} \item{NN3.070}{a numeric vector containing
#' the 121 observations of a univariate time series.} \item{NN3.071}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.072}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3.073}{a numeric vector containing
#' the 126 observations of a univariate time series.} \item{NN3.074}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.075}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3.076}{a numeric vector containing
#' the 126 observations of a univariate time series.} \item{NN3.077}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.078}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3.079}{a numeric vector containing
#' the 126 observations of a univariate time series.} \item{NN3.080}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.081}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3.082}{a numeric vector containing
#' the 116 observations of a univariate time series.} \item{NN3.083}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.084}{a numeric vector containing the 122 observations of a
#' univariate time series.} \item{NN3.085}{a numeric vector containing
#' the 126 observations of a univariate time series.} \item{NN3.086}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.087}{a numeric vector containing the 121 observations of a
#' univariate time series.} \item{NN3.088}{a numeric vector containing
#' the 78 observations of a univariate time series.} \item{NN3.089}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.090}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3.091}{a numeric vector containing
#' the 116 observations of a univariate time series.} \item{NN3.092}{a
#' numeric vector containing the 115 observations of a univariate time series.}
#' \item{NN3.093}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3.094}{a numeric vector containing
#' the 116 observations of a univariate time series.} \item{NN3.095}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.096}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3.097}{a numeric vector containing
#' the 126 observations of a univariate time series.} \item{NN3.098}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3.099}{a numeric vector containing the 115 observations of a
#' univariate time series.} \item{NN3.100}{a numeric vector containing
#' the 116 observations of a univariate time series.} \item{NN3_101}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3_102}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3_103}{a numeric vector containing
#' the 126 observations of a univariate time series.} \item{NN3_104}{a
#' numeric vector containing the 115 observations of a univariate time series.}
#' \item{NN3_105}{a numeric vector containing the 126 observations of a
#' univariate time series.} \item{NN3_106}{a numeric vector containing
#' the 126 observations of a univariate time series.} \item{NN3_107}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3_108}{a numeric vector containing the 115 observations of a
#' univariate time series.} \item{NN3_109}{a numeric vector containing
#' the 123 observations of a univariate time series.} \item{NN3_110}{a
#' numeric vector containing the 126 observations of a univariate time series.}
#' \item{NN3_111}{a numeric vector containing the 126 observations of a
#' univariate time series.} }
#' @seealso \code{\link{NN3.A.cont}} ~
#' @references S.F. Crone, M. Hibon, and K. Nikolopoulos, 2011, Advances in
#' forecasting with neural networks? Empirical evidence from the NN3
#' competition on time series prediction, International Journal of Forecasting,
#' v. 27, n. 3 (Jul.), p. 635-660. 
#' @source NN3 2007, The NN3 Competition: Forecasting competition for
#' artificial neural networks and computational intelligence. URL:
#' \url{http://www.neural-forecasting-competition.com/NN3/index.htm}. 
#' @keywords datasets NN3 Time Series Competition
#' @examples
#' 
#' data(NN3.A)
#' str(NN3.A)
#' plot(ts(NN3.A["NN3_111"]))
#' 
"NN3.A"
#> [1] "NN3.A"