% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginalgame.R
\name{marginalgame}
\alias{marginalgame}
\title{Marginal game}
\usage{
marginalgame(v, S, binary = FALSE)
}
\arguments{
\item{v}{Characteristic function, as a vector.}

\item{S}{The position of a coalition, as an integer.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} and \code{S} are introduced according to binary order instead of lexicographic order.}
}
\value{
The characteristic function of the \code{S}-marginal game, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
Given a game and a coalition, this function returns the characteristic function of the corresponding marginal game.
}
\details{
Given a game \eqn{v\in G^N} and a coalition \eqn{S\in 2^N}, the S-marginal game, \eqn{v^S\in G^N},
is defined by \deqn{v^S(R)=v(R\cup (N\backslash S))-v(N\backslash S)+v(R\cap (N\backslash S))\text{ for all }R\in 2^N.}
}
\examples{
v <- c(0, 0, 0, 2, 3, 10, 20)
marginalgame(v, 5, binary = TRUE) # coalition {1,3}
n <- 3
for (i in 1:(2^n - 1)) {
  cat("[", i, "]", paste(marginalgame(lex2bin(v),codebin2lex(n,i),binary=TRUE)),"\n")
}
for (i in 1:(2^n - 1)) {
  cat("[", i, "]", paste(marginalgame(v,i)),"\n")
}
}
\references{
Sánchez Rodríguez, E., Mirás Calvo, M.A., Quinteiro Sandomingo, C., & Núñez Lugilde, I. (2024). Coalition-weighted Shapley values. International Journal of Game Theory 53, 547-577.
}
