% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egalitarian.R
\name{egalitarian}
\alias{egalitarian}
\title{Egalitarian value}
\usage{
egalitarian(characteristic_func, n_players = 0)
}
\arguments{
\item{characteristic_func}{The valued function defined on the subsets of the number
of players}

\item{n_players}{Only used if \code{characteristic_func} is a \code{function}.
The number of players in the game.}
}
\value{
The egalitarian value for each player
}
\description{
Calculate the egalitarian value
}
\examples{
n <- 10
v <- function(coalition) {
  if (length(coalition) > n/2) {
    return(1)
  } else {
    return(0)
  }
}
egalitarian(v,n)

v <- c(1,1,2,1,2,2,2)
egalitarian(v)

}
